package org.bloginthecloud.sample;

import java.io.*;
import java.util.regex.*;
import org.jdom.*;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.restlet.data.Response;

public class QueueMessage {
	public String text;
	public String popReceipt;
	public String id;
	
	public QueueMessage(String xml) throws JDOMException, IOException{
		ParseXml(xml);
	}
	
	public QueueMessage(Response response) throws JDOMException, IOException{
		StringWriter writer = new StringWriter();
		response.getEntity().write(writer);
		ParseXml(writer.toString());
	}
	
	public void ParseXml(String xml) throws JDOMException, IOException{
		Matcher junkMatcher = 
			(Pattern.compile("^([\\W]+)<")).matcher(xml.trim());
		xml = junkMatcher.replaceFirst("<");
		
		StringReader reader = new StringReader(xml);
		SAXBuilder sxb = new SAXBuilder();
		Document document = null;
		document = sxb.build(reader);
		
		Element element = document.getRootElement().getChild("QueueMessage");
		
		id = element.getChild("MessageId").getValue();
		popReceipt = element.getChild("PopReceipt").getValue();
		text = element.getChild("MessageText").getValue();
	}
}